//=============================================================================
// RPGツクールMV - セーブスロットロックプラグイン
//=============================================================================

/*:
 * @plugindesc セーブスロットのロック機能を追加します。
 * @author あなたの名前
 *
 * @help
 * このプラグインは、特定のセーブスロットをロックし、
 * 上書きできないようにする機能を追加します。
 *
 * プラグインコマンド:
 *   LockSaveSlot n     // n番目のセーブスロットをロックします。
 *   UnlockSaveSlot n   // n番目のセーブスロットのロックを解除します。
 *
 * 注意:
 *   - セーブスロットの番号は1から始まります。
 *   - ロックされたセーブスロットには上書きできませんが、ロードは可能です。
 */

var Imported = Imported || {};
Imported.SaveSlotLock = true;

//-----------------------------------------------------------------------------
// DataManager
//-----------------------------------------------------------------------------

var _DataManager_saveGame = DataManager.saveGame;
DataManager.saveGame = function(savefileId) {
    if ($gameSystem.isSaveSlotLocked(savefileId)) {
        console.warn(`セーブスロット ${savefileId} はロックされています。セーブできません。`);
        return false;
    }
    return _DataManager_saveGame.apply(this, arguments);
};

//-----------------------------------------------------------------------------
// Game_Interpreter
//-----------------------------------------------------------------------------

var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    if (command === 'LockSaveSlot') {
        $gameSystem.lockSaveSlot(Number(args[0]));
    } else if (command === 'UnlockSaveSlot') {
        $gameSystem.unlockSaveSlot(Number(args[0]));
    }
};

//-----------------------------------------------------------------------------
// Game_System
//-----------------------------------------------------------------------------

var _Game_System_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {
    _Game_System_initialize.call(this);
    this._saveSlotLocks = []; // 必ず配列として初期化
};

Game_System.prototype.lockSaveSlot = function(savefileId) {
    this._saveSlotLocks = this._saveSlotLocks || []; // 初期化されていない場合の保険
    if (!this._saveSlotLocks.includes(savefileId)) {
        this._saveSlotLocks.push(savefileId);
        console.log(`セーブスロット ${savefileId} をロックしました。`);
    }
};

Game_System.prototype.unlockSaveSlot = function(savefileId) {
    this._saveSlotLocks = this._saveSlotLocks || []; // 初期化されていない場合の保険
    var index = this._saveSlotLocks.indexOf(savefileId);
    if (index >= 0) {
        this._saveSlotLocks.splice(index, 1);
        console.log(`セーブスロット ${savefileId} のロックを解除しました。`);
    }
};

Game_System.prototype.isSaveSlotLocked = function(savefileId) {
    this._saveSlotLocks = this._saveSlotLocks || []; // 初期化されていない場合の保険
    return this._saveSlotLocks.includes(savefileId);
};